/*
 * Decompiled with CFR 0.152.
 */
package vazkii.patchouli.client.book;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import vazkii.patchouli.api.PatchouliAPI;
import vazkii.patchouli.common.util.ItemStackUtil;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface BookIcon {
    public void render(GuiGraphics var1, int var2, int var3);

    public static BookIcon from(String str) {
        if (str.endsWith(".png")) {
            return new TextureIcon(new ResourceLocation(str));
        }
        try {
            ItemStack stack = ItemStackUtil.loadStackFromString(str);
            return new StackIcon(stack);
        }
        catch (Exception e) {
            PatchouliAPI.LOGGER.warn("Invalid icon item stack: {}", (Object)e.getMessage());
            return new StackIcon(ItemStack.f_41583_);
        }
    }

    public record TextureIcon(ResourceLocation texture) implements BookIcon
    {
        @Override
        public void render(GuiGraphics graphics, int x, int y) {
            graphics.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
            graphics.m_280163_(this.texture(), x, y, 0.0f, 0.0f, 16, 16, 16, 16);
        }
    }

    public record StackIcon(ItemStack stack) implements BookIcon
    {
        @Override
        public void render(GuiGraphics graphics, int x, int y) {
            graphics.m_280480_(this.stack(), x, y);
            graphics.m_280370_(Minecraft.m_91087_().f_91062_, this.stack(), x, y);
        }
    }
}

